<html>
<head><title>Moja biblioteczka</title><meta http-equiv="Content-Type" content="text/html; charset=utf-8"></head>
<body>
<?php
 class BookList {
   var $parser;
   var $record;
   var $current_field = '';
   var $field_type;
   var $ends_record;
   var $records;

   function BookList ($filename) {
     $this->parser = xml_parser_create(  );
     xml_set_object($this->parser, &$this);
     xml_set_element_handler($this->parser, 'start_element', 'end_element');
     xml_set_character_data_handler($this->parser, 'cdata');

     // 1 = pojedyncze pole, 2 = tablica, 3 = kontener rekordów
     $this->field_type = array('title' => 1,
                               'author' => 2,
                               'isbn' => 1,
                               'comment' => 1);
     $this->ends_record = array('book' => true);

     $x = join("", file($filename));
     xml_parse($this->parser, $x);
     xml_parser_free($this->parser);
   }

   function start_element ($p, $element, &$attributes) {
     $element = strtolower($element);
     if ($this->field_type[$element] != 0) {
       $this->current_field = $element;
     } else {
       $this->current_field = '';
     }
   }

   function end_element ($p, $element) {
     $element = strtolower($element);
     if ($this->ends_record[$element]) {
       $this->records[] = $this->record;
       $this->record = array(  );
     }
     $this->current_field = '';
   }

   function cdata ($p, $text) {
     if ($this->field_type[$this->current_field] === 2) {
       $this->record[$this->current_field][] = $text;
     } elseif ($this->field_type[$this->current_field] === 1) {
       $this->record[$this->current_field] .= $text;
     }
   }

   function show_menu(  ) {
     echo "<table border=1>\n";
     foreach ($this->records as $book) {
       echo "<tr>";
       $authors = join(', ', $book['author']);
       printf("<th><a href='%s'>%s</a></th><td>%s</td></tr>\n",
              $_SERVER['PHP_SELF'] . '?isbn=' . $book['isbn'],
              $book['title'],
              $authors);
       echo "</tr>\n";
     }
   }

   function show_book ($isbn) {
     foreach ($this->records as $book) {
       if ($book['isbn'] !== $isbn) {
         continue;
       }

       $authors = join(', ', $book['author']);
       printf("<b>%s</b> autor: %s.<br>", $book['title'], $authors);
       printf("ISBN: %s<br>", $book['isbn']);
       printf("Komentarz: %s<p>\n", $book['comment']);
     }
?>
Powrót do <a href="<?= $_SERVER['PHP_SELF'] ?>">listy książek</a>.<p>
<?
   }
 }; // kod główny programu

 $my_library = new BookList ("books.xml");
 if ($_GET['isbn']) {
   // zwróć informacje na temat jednej książki
   $my_library->show_book($_GET['isbn']);
 } else {
   // pokaż menu książek
   $my_library->show_menu(  );
 }
?>
</body></html>
